#!/usr/local/bin/perl
#
#  main.pl     LabIV main control function. This will be
#              drastically changed for real production.
#
$local_dir = "/usr/local/LabIV/BETA1";  #set this to the local dir
require "$local_dir/labiv.conf";

get_ftp_file($hosts_server, $hosts_loginId, $hosts_loginPW,
               $hosts_dir, $hosts_file);

parse_hosts_file($hosts_local_file);
my ($arg_t, $arg_c, $arg_d) = get_args();

if (!$arg_t) {
   $arg_t = "[^gd]..";
}
if (!$arg_d) {
   print "The -d option is currently required for this beta release\n";
   exit();
}

@keys = search_by_name("$arg_t$dev_profile{$arg_d}->{'name'}");

print "Name         CPU       SwitchCard  FeatureCard  Status\n";
print "------------------------------------------------------\n";

$e_status_total = 0;
$c_status_total = 0;
$m_status_total = 0;
$f_status_total = 0;

foreach $key (@keys) {
   if ($arg_c eq 'cpu') {
     if ($dev_profile{$arg_d}->{"cpu_line"}) {
        $p_cpu = parse_ver($dev_profile{$arg_d}->{"cpu_line"},
                           $dev_profile{$arg_d}->{"cpu_ver"}, 
        getinfo($name[$key], $termserv[$key], $termserv_port[$key],
            $dev_profile{$arg_d}->{"cpu_cmd"}));
     }
   }
   elsif ($arg_c eq 'sc') {
     if ($dev_profile{$arg_d}->{"sc_line"}) {
        $p_sc = parse_ver($dev_profile{$arg_d}->{"sc_line"},
                          $dev_profile{$arg_d}->{"sc_ver"},
        getinfo($name[$key], $termserv[$key], $termserv_port[$key],
            $dev_profile{$arg_d}->{"sc_cmd"}));
     }
   }
   elsif ($arg_c eq 'fc') {
     if ($dev_profile{$arg_d}->{"fc_line"}) {
        $p_fc = parse_ver($dev_profile{$arg_d}->{"fc_line"},
                          $dev_profile{$arg_d}->{"fc_ver"},
        getinfo($name[$key], $termserv[$key], $termserv_port[$key],
            $dev_profile{$arg_d}->{"fc_cmd"}));
     }
   }
   else {
     if ($dev_profile{$arg_d}->{"cpu_line"}) {
        $p_cpu = parse_ver($dev_profile{$arg_d}->{"cpu_line"},
                           $dev_profile{$arg_d}->{"cpu_ver"},
        getinfo($name[$key], $termserv[$key], $termserv_port[$key],
            $dev_profile{$arg_d}->{"cpu_cmd"}));
     }

     if ($dev_profile{$arg_d}->{"sc_line"}) {
        $p_sc = parse_ver($dev_profile{$arg_d}->{"sc_line"},
                          $dev_profile{$arg_d}->{"sc_ver"},
        getinfo($name[$key], $termserv[$key], $termserv_port[$key],
            $dev_profile{$arg_d}->{"sc_cmd"}));
     }
     if ($dev_profile{$arg_d}->{"fc_line"}) {
        $p_fc = parse_ver($dev_profile{$arg_d}->{"fc_line"},
                          $dev_profile{$arg_d}->{"fc_ver"},
        getinfo($name[$key], $termserv[$key], $termserv_port[$key],
            $dev_profile{$arg_d}->{"fc_cmd"}));
     }

   }
   my $status = connection_status($name[$key]);
   if ($status eq "undefined:problem creating socket: Too many open files") {
      print "Disconnecting all devices...\n";
      disconnect();
   }
   if ($status eq "Ethernet") {
      $p_status = "E";
      $e_status_total++;
   }
   elsif ($status eq "Console") {
      $p_status = "C";
      $c_status_total++;
   }
   elsif ($status eq "monitor") {
      $p_status = "M";
      $m_status_total++;
   }
   else {
      $p_status = "F";
      $f_status_total++;
   }
   write;
}
print "\n";

$status_total = $e_status_total + $c_status_total + $f_status_total +$m_status_total;
print "$e_status_total Ethernet + $c_status_total Console + $m_status_total Monitor + $f_status_total Failed = $status_total Total Devices\n";

disconnect();
