########################################################################
# Inputs:     none
# Outputs:    returns an array containing the values of each flag
########################################################################
sub get_args {
   use Getopt::Std;
   if (getopts("t:d:xf:q:D")) {
      return;
   }
   else {
      print "  Phil's LabIV usage:.\n";
      print "  labiv -t <testbed> -d <device type> -f <feature> -q <quality>\n";
      print "  labiv -t gd30      -d 8540          -f sc        -q hw_ver\n";
      print "  labiv -x   (enable console login)\n";
      print "  labiv -D   Display all available device profile information\n\n";
      print "  If any option is omitted, all possibilities will be used.\n";
      print "     ie:  labiv -t cs01 -f cpu -q fpga_ver\n";
      print "     This will check the cpu fgpa_ver of ALL devices because\n";
      print "     the -d option is missing.\n";
      exit -1;
   }
}
1;
