########################################################################
# Subroutine: get_ftp_file
# Inputs:     get_ftp_file(server, loginID, loginPW, dir, file);
# Outputs:    leaves the file in the current working directory
########################################################################
sub get_ftp_file {
   my ($server, $loginID, $loginPW, $dir, $file) = @_;
 
   use Net::FTP;
 
   print "Retrieving $dir/$file from $server\n";
   my $ftp = Net::FTP->new("$server") or die "HALT: Could not contact $server\n"
;
   $ftp->login("$loginID","$loginPW") or die "HALT: Bad passwd or login id.\n";
   $ftp->cwd("$dir") or die "HALT: $dir does not exist on $server\n";
   $ftp->get("$file") or die "HALT: $file does not exist in $dir\n";
   $ftp->quit;
   print "Transfer complete.\n";
}
1;
