# parse.pl
#

sub parse_ver {
   my ($cmdResults, @Pattern) = @_;
   my $out;
   $_ = $cmdResults;
   while ($_) {                        # while new text still exists 
      my $outermost = 1;
      my $rest;
      my $found;
 
      foreach $pattern (@Pattern) {    # iterate through $pattern until it has
         s/$pattern//s;                #    "cut" specified text
         if ($outermost) {             # save remaining text to be parsed next
            $rest = $';
            $outermost = 0;
         }
         $found = $&;
         $_ = $&;
      }
      if ($rest) {                     # if unparsed text remains
         $found =~ tr/;//s;
         if ($out ) {
            $out = "$out;$found";      # save results (after first)
         }
         else {
            $out = "$found";           # save first results
         }
         $_ = $rest;                   # set unparsed text to be input next
      }
      else {
         $_ = 0;                       # no unparsed text reamains, bail out.
      }
   }
   return $out;                        # return results as a space deliminated
}                                      #    string.      " 3.0 2.1 2.4" 

1;
