# stats.pl
#
$hstats_total = 0.0;

sub s_add_data {
   my ($stringData, $device, $feature, $quality) = @_;

   my @results = split(';', $stringData);

   foreach $result (@results) {
      if ($hresults{$device}->{$feature}->{$quality}->{"$result"}) {
         $hresults{$device}->{$feature}->{$quality}->{"$result"} =
            $hresults{$device}->{$feature}->{$quality}->{"$result"} + 1;
      }
      else {
         $hresults{$device}->{$feature}->{$quality}->{"$result"} = 1;
      } 
   }

}

sub s_dump_data {

   print "*** Results:    (count in parens) ***\n";
   foreach $device ( keys %hresults ) {
      print "$device\n";
 
      my $features = $hresults{$device};
      foreach $feature ( keys %$features ) {
         print "   $feature\n";
         my $qualities = $hresults{$device}->{$feature};
         foreach $quality ( keys %$qualities ) {
            print "      $quality:";
            my $results = $hresults{$device}->{$feature}->{$quality};
            foreach $result ( sort keys %$results ) {
               print " $result";
               print "($hresults{$device}{$feature}{$quality}{$result})";
            }
            print "\n";
         }
      }
   }
}

sub s_add_status {
   my ($status) = @_;
   if ( $hstats{"$status"} ) {
      $hstats{"$status"} = $hstats{"$status"} + 1;
   }
   else {
      $hstats{"$status"} = 1.0;
   } 
   $hstats_total = $hstats_total + 1.0;
}

sub s_dump_status {
   print "Connection summery:\n";
   foreach $p_status ( keys %hstats ) {
      my $percentage = 100 * $hstats{"$p_status"} / $hstats_total;
      print "   $p_status";
      print " $hstats{\"$p_status\"}";
      #print " ($percentage\%)";
      printf("  %.2f\%\n", $percentage);

   }
   print "   Total:   $hstats_total\n";

}

1;
