# hosts.pl
# 
########################################################################
# Inputs:     parse_hosts_file("filename");
# Outputs:    stores IP and NAME in global arrays with the same keys
########################################################################
sub parse_hosts_file {
   my $lineData;
   my $line;
    
   print "Parsing hosts file\n";
   open (HOSTS, $_[0]) or die "HALT: Can't open $!\n";
   my @LINES = <HOSTS>;
   close(HOSTS);

   my $inc = "0";
   foreach $line (@LINES) {
      ($lineData, $LineComments) = split("#", $line, 2);
      $lineData =~ tr/ /\t/s;       #squeeze multiple spaces to one tab char
      $LineComments =~ tr/\t/ /s;   #squeeze multiple tabs to one space char
      $LineComments =~ tr/ //s;     #squeeze multiple spaces to one
      chomp $lineData;
      
print $LineComments;

      if ( $LineComments =~ /(termserv_|t)[0-9]* 20[0-9][0-9]/ ) {
         if ( $LineComments =~ /(termserv_|t)[0-9]*/ ) {
            $termserv[$inc] = $&;
         }
         if ( $LineComments =~ /20[0-9][0-9]/ ) {
            $termserv_port[$inc] = $&;
         }
      }

      if ($lineData ne "") {
         ($ip[$inc], $name[$inc], undef) = split(/\t+/, $lineData, 3);
      }
      $inc++; 
   }
}

########################################################################
# Inputs:     search_by_name("your regexp");
#             search_by_name("gd.._[c|m]84");
# Outputs:    returns array of keys indexing found values in @name
########################################################################
sub search_by_name {
   my $size = @name;
   my $pattern = $_[0];
   print "Searching for $pattern\n";
 
   for (my $inc = 0; $inc < $size; $inc++) {
      $_ = $name[$inc];
      if ( /$pattern/ ) {
          @found = (@found, $inc);
      }
   }
   @found;
}

1;
