#!/usr/local/bin/perl
#
#  main.pl     LabIV main control function. 
#
require "labiv.conf";
 
get_args();

if ($opt_D) {
   list_dev();
   exit();
}

get_ftp_file($hosts_server, $hosts_loginId, $hosts_loginPW,
               $hosts_dir, $hosts_file);
 
parse_hosts_file($hosts_local_file);

 
if (!$opt_t) {
   @testbeds = ('[^gd]..');
}
else {
   @testbeds = split(',', $opt_t);
}

if (!$opt_d) {
   @devices = ( keys %dp );
}
else {
   @devices = split(',', $opt_d);
}

foreach $testbed (@testbeds) {
   print "Testbed: $testbed\n";

   foreach $device (@devices) {
      print "Dev: $device\n";

      foreach $key (search_by_name("$testbed$dp{$device}->{'name'}")) {
         $features = $dp{$device};

         if (!$opt_f) {
            @features = ( keys %$features );
         }
         else {
            @features = split(',', $opt_f);
         }
         foreach $feature ( @features ) {
            if ($feature ne 'name') {
               print "  Feature $feature:   ";
               if (!$opt_q) {
                  $qualities = $dp{$device}->{$feature};
                  @qual_to_search = ( keys %$qualities );
               }
               else {
                  @qual_to_search = split(',', $opt_q);
               }

               foreach $quality ( @qual_to_search ) {
                  $parse_lines = $dp{$device}->{$feature}->{$quality}->{'parse'};
                  $dev_info =  
                    getinfo($name[$key], $termserv[$key], $termserv_port[$key],
                    $dp{$device}->{$feature}->{$quality}->{'cmd'} );
                  $dev_res = parse_ver( $dev_info, @$parse_lines );
                  if ($dev_res) {
                     chomp $dev_res;
                     print "$quality ";
                     print "$dev_res ";
                  }
                  s_add_data($dev_res,$device,$feature,$quality);
               }
               print "\n";
            }
         }
         my $status = connection_status($name[$key]);
         s_add_status($status);
         print "$name[$key] $termserv[$key] $termserv_port[$key] Status: $status\n\n";
         disconnect($name[$key]);
      }
   }
}
disconnect();
s_dump_data();
s_dump_status();
