########################################################################
# Subroutine: get_hosts_file
# Inputs:     get_hosts_file(server, loginID, loginPW, dir, file);
# Outputs:    leaves the file in the current working directory
########################################################################
sub get_hosts_file {
   my $server = $_[0];
   my $loginID = $_[1];
   my $loginPW = $_[2];
   my $dir = $_[3];
   my $file = $_[4];

   use Net::FTP;

   print "Retrieving $dir/$file from $server\n";
   $ftp = Net::FTP->new("$server") || die "HALT: Could not contact $server\n";
   $ftp->login("$loginID","$loginPW") || die "HALT: Bad passwd or login id.\n";
   $ftp->cwd("$dir") || die "HALT: $dir does not exist on $server\n";
   $ftp->get("$file") || die "HALT: $file does not exist in $dir\n";
   $ftp->quit;
   print "Transfer complete.\n";
}

########################################################################
# Subroutine: parse_hosts_file
# Inputs:     parse_hosts_file("filename");
# Outputs:    stores IP and NAME in global arrays with the same keys
########################################################################
sub parse_hosts_file {
   print "Parsing hosts file\n";
   open (HOSTS, $_[0]) || die "HALT: Can't open $!\n";
   @LINES = <HOSTS>;
   close(HOSTS);

   my $inc = "0";
   foreach $line (@LINES) {
      ($lineData, $LineComments) = split("#", $line, 2);
      $lineData =~ tr/ /\t/s;       #squeeze multiple spaces to one tab char
      $lineData =~ tr/\t//s;        #squeeze multiple tabs to one tab char
      $/ = "\n"; 
      chomp $lineData;
      
      if ($lineData ne "") {
         ($ip[$inc], $name[$inc], undef) = split("\t", $lineData, 3);
         $inc++; 
      }
   }
}

1;
