# net.pl
# Handeles the telnet connection to the devices. This will change
# with the introduction of the data structure that holds the results. 
#
########################################################################
# Subroutine: net_connect
# Inputs:     net_connect(host, command);
# Outputs:    returns array with the results of the command
########################################################################
sub net_connect2 {
   $Out = 0;
   use Net::Telnet;
   $t = new Net::Telnet;
   $t->prompt('/[\$%#>:]$/');
   $t->errmode("return");
   $t->timeout("3");
   $t->open($_[0]);
   $t->waitfor('/[:#>].*$/');

   if ($t->errmsg) {
      $Out = $t->errmsg;
#      print "$Out\n";
      $_ = $Out;
      if (/connection timed-out/) {
         print "Connection Timed-out. Ethernet port down\n";
      }
      $_ = $Out;
      if (/pattern match read eof/) {
         print "Password required but none set\n";
      }
   }

   $t->print("lab");
   $t->getlines;

   $t->cmd("en");
   $t->cmd("lab");

   @cmdResults = $t->cmd($_[1]);
#   print "@cmdResults\n";

   $t->close;
   return @cmdResults;
}

sub net_connect {
   net_connect2(@_);
#   $msg = $t->errmsg;
#   print "$msg";
}

########################################################################
# Subroutine: hardware_8540_cpu 
# Inputs:     hardware_8540_cpu(StringOfCommandOutput)
# Outputs:    prints out cards found in slots 4 or 8 (cpu)
########################################################################
sub hardware_8540_cpu {
#  my $pattern = "Route Proc";
   my $pattern = '(8|4)\/\*';
   my $pat = "[0-9| ][0-9][\.][0-9]";
   my $output;

   my @lines = @_;
 
   foreach $line (@lines) { 
      $_ = $line;
      if ( /$pattern/ ) {
         if ( /$pat/ ) {
             #print "$&";
             $output = "$output $&";
         }
      }
   }
   $output;
}

########################################################################
# Subroutine: hardware_8540_cpuFPGA
# Inputs:     hardware_8540_cpu
# Outputs:    prints out cards found in slots 4 or 8 (cpu)
########################################################################
sub hardware_8540_cpuFPGA {
   my $pattern = 'Functional Version of the FPGA Image';
   my $pat = "[0-9| ][0-9][\.][0-9]";
   my $output;
   for ($i=4; $i<9; $i+=4) {
      my @lines = net_connect($ip[$key], "sh fu slot $i");;
      foreach $line (@lines) { 
         $_ = $line;
         if (/$pattern/ ) {
         if ( /$pat/ ) {
            $output = "$output $&";
         }
         }
      }
   }
   $output;
}

########################################################################
# Subroutine: hardware_8540_switchcFPGA
# Inputs:     
# Outputs:    prints out FPGA of cards found in slots 5, 6 or 7  
########################################################################
sub hardware_8540_switchcFPGA {
   my $pattern = 'Functional Version of the FPGA Image';
   my $pat = "[0-9| ][0-9][\.][0-9]";
   my $output;
   for ($i=5; $i<8; $i++) {
      my @lines = net_connect($ip[$key], "sh fu slot $i");;
      foreach $line (@lines) { 
         $_ = $line;
         if (/$pattern/ ) {
         if ( /$pat/ ) {
            $output = "$output $&";
         }
         }
      }
   }
   $output;
}

########################################################################
# Subroutine: hardware_8540_switchc
# Inputs:     hardware_8540_switchc(ArraryOfCommandOutput)
# Outputs:    prints out cards found in slots 5, 6 or 7 (switch cards)  
########################################################################
sub hardware_8540_switchc {
#  my $pattern = "Switch Card";
   my $pattern = '[5-7]\/\*';
   my $pat = "[0-9| ][0-9][\.][0-9]";
   my $output;

   my @lines = @_;
 
   foreach $line (@lines) { 
      $_ = $line;
      if ( /$pattern/ ) {
         if ( /$pat/ ) {
             #print "$&";
             $output = "$output $&";
         }
      }
   }
   $output;
}
1;

# /usr/local/lib/perl5/5.00502/man/man3   dice.cisco.com
# /usr/lib/perl5/5.00502/man/man3         wormhole.punk.net
