%results = {};
use Net::Telnet;

sub getinfo {
   my ($dev, $cmd) = @_;
   if ( prev_run($dev,$cmd) ) {
      print "Looking up ";
      return lookup($dev,$cmd);
   }
   else {
      if ( !connected($dev,$cmd) ) {
         n_connect($dev);
      }
      print "A new run ";
      run_cmd($dev,$cmd);
      return lookup($dev,$cmd);
   }
}

sub prev_run {
   my ($dev, $cmd) = @_;
   if ( exists $results{"$dev"}->{"$cmd"} ) {
      return 1;
   } 
   else {
      return 0;
   }
}

sub lookup {
   my ($dev, $cmd) = @_;
   return $results{"$dev"}->{"$cmd"};
}

sub connected {
   my ($dev, $cmd) = @_;
   if ($connections{"$dev"}) {
      return 1;
   }
   else {
      return 0;
   }
}

sub n_connect {
   my ($dev) = @_;
   $connections{"$dev"} = new Net::Telnet;
   $connections{"$dev"}->prompt('/[\$%#>:]$/');
   $connections{"$dev"}->errmode("return");
   $connections{"$dev"}->timeout("3");
   $connections{"$dev"}->open($dev);
   $connections{"$dev"}->waitfor('/[:#>].*$/');

   if ($connections{"$dev"}->errmsg) {
      $Out = $connections{"$dev"}->errmsg;
      if ($Out =~ /connection timed-out/) {
         print "Connection Timed-out. Ethernet port down\n";
      }
      if ($Out =~ /pattern match read eof/) {
         print "Password required but none set\n";
      }
      return 0;
   }
   $connections{"$dev"}->print("lab");
   $connections{"$dev"}->getlines;
   $connections{"$dev"}->cmd("en");
   $connections{"$dev"}->cmd("lab");
   return 1;
}

sub run_cmd {
   my ($dev, $cmd) = @_;
   $results{"$dev"}->{"$cmd"} = "";

   foreach $cmd_line ($connections{"$dev"}->cmd("$cmd")) {
      $results{$dev}->{$cmd} = "$results{$dev}->{$cmd}$cmd_line";
   }
#   print "OUTPUT WAS: $results{$dev}->{$cmd}\n";
}

sub disconnect {
   $connections{"$dev"}->close;
}

1;
