#!/usr/local/bin/perl
#
#  main.pl     LabIV main control function. This will be
#              drastically changed for real production.
#
require "./labiv.conf";

get_hosts_file($hosts_server, $hosts_loginId, $hosts_loginPW,
               $hosts_dir, $hosts_file);

parse_hosts_file($hosts_local_file);
@keys = search_by_name("$ARGV[0]");

#lookup_by_key(@keys);

foreach $key (@keys) {
   print "$ip[$key] $name[$key]\n";
   if ($ARGV[1] eq 'cpu') {
      print hardware_8540_cpu(getinfo($ip[$key], "sh hard"));
   }
   elsif ($ARGV[1] eq 'sc') {
      print hardware_8540_switchc(getinfo($ip[$key], "sh hard"));
   }
   else {
      print "CPU:             ";
      print hardware_8540_cpu(getinfo($ip[$key], "sh hard"));

      print "\nCPU FPGA:        ";
      print hardware_8540_cpuFPGA(getinfo($ip[$key], "sh fu slot 4"));
      print hardware_8540_cpuFPGA(getinfo($ip[$key], "sh fu slot 8"));

      print "\nSwitchCard:      ";
      print hardware_8540_switchc(getinfo($ip[$key], "sh hard"));

      print "\nSwitchCard FPGA: "; 
      print hardware_8540_switchcFPGA(getinfo($ip[$key], "sh fu slot 5"));
      print hardware_8540_switchcFPGA(getinfo($ip[$key], "sh fu slot 6"));
      print hardware_8540_switchcFPGA(getinfo($ip[$key], "sh fu slot 7"));
   }
   print "\n\n";
}
disconnect();
