%results = {};
use Net::Telnet;

sub getinfo {
   my ($dev, $cmd) = @_;
   if (check_errors($dev)) {             # stop if previous connection errors
      print "err ";
      return -1;
   }
   elsif ( prev_run($dev,$cmd) ) {       # lookup if command already run
      print "Looking up ";
      return lookup($dev,$cmd);
   }
   else {                                # run the command
      if ( !connected($dev) ) {          # if not connected: connect
         n_connect($dev);
      }
      print "new ";
      run_cmd($dev,$cmd);
      return lookup($dev,$cmd);
   }
}

sub prev_run {
   my ($dev, $cmd) = @_;
   if ( exists $results{"$dev"}->{"$cmd"} ) {
      return 1;
   } 
   else {
      return 0;
   }
}

sub lookup {
   my ($dev, $cmd) = @_;
   return $results{"$dev"}->{"$cmd"};
}

sub connected {
   my ($dev) = @_;
   if ($connections{"$dev"}) {
      return 1;
   }
   else {
      return 0;
   }
}

sub check_errors {
   my ($dev) = @_;
   if ( $con_errors{"$dev"} ) {
      return 1;
   }
   else {
      return 0;
   }
}

sub n_connect {
   my ($dev) = @_;
   $connections{"$dev"} = new Net::Telnet;
   $connections{"$dev"}->prompt('/[\$%#>:]$/');
   $connections{"$dev"}->errmode("return");
   $connections{"$dev"}->timeout("3");
   $connections{"$dev"}->open($dev);
   $connections{"$dev"}->waitfor('/[:#>].*$/');

   if ($connections{"$dev"}->errmsg) {
      my $Out = $connections{"$dev"}->errmsg;
      if ($Out =~ /connection timed-out/) {
         print "Connection Timed-out. Ethernet port down\n";
         $con_errors{"$dev"} = "timed-out";
      }
      elsif ($Out =~ /pattern match read eof/) {
         print "Password required but none set\n";
         $con_errors{"$dev"} = "nopasswd";
      }
      else {
         $con_errors{"$dev"} = $Out;
      }
      return 0;
   }
   else {
      push(@connected_to,($dev));
      $connections{"$dev"}->print("lab");
      $connections{"$dev"}->getlines;
      $connections{"$dev"}->cmd("en");
      $connections{"$dev"}->cmd("lab");
      return 1;
   }
}

sub run_cmd {
   my ($dev, $cmd) = @_;
   $results{"$dev"}->{"$cmd"} = "";

   foreach $cmd_line ($connections{"$dev"}->cmd("$cmd")) {
      $results{$dev}->{$cmd} = "$results{$dev}->{$cmd}$cmd_line";
   }
}

sub disconnect {
   print "Disconnecting...\n";
   foreach $dev (@connected_to) {
      print "Closing: $dev\n";
      $connections{"$dev"}->close;
   }
}

1;
