#!/usr/local/bin/perl
#
#  main.pl     LabIV main control function. This will be
#              drastically changed for real production.
#
require "./labiv.conf";

get_ftp_file($hosts_server, $hosts_loginId, $hosts_loginPW,
               $hosts_dir, $hosts_file);

parse_hosts_file($hosts_local_file);
@keys = search_by_name("$ARGV[0]");

print "Name         CPU       Switch Card  Status\n";
print "------------------------------------------\n";

$e_status_total = 0;
$c_status_total = 0;
$m_status_total = 0;
$f_status_total = 0;

foreach $key (@keys) {
   #print "$ip[$key] $name[$key] $termserv[$key] $termserv_port[$key]\n";
   if ($ARGV[1] eq 'cpu') {
      print hardware_8540_cpu(
          getinfo($ip[$key], $termserv[$key], $termserv_port[$key], "sh hard"));
      print "\n\n";
   }
   elsif ($ARGV[1] eq 'sc') {
      print hardware_8540_switchc(
          getinfo($ip[$key], $termserv[$key], $termserv_port[$key], "sh hard"));
      print "\n\n";
   }
   else {
     $p_cpu = hardware_8540_cpu(
     getinfo($name[$key], $termserv[$key], $termserv_port[$key], "sh hard"));

     $p_sc = hardware_8540_switchc(
     getinfo($name[$key], $termserv[$key], $termserv_port[$key], "sh hard"));

     my $status = connection_status($name[$key]);
     if ($status eq "Ethernet") {
        $p_status = "E";
        $e_status_total++;
     }
     elsif ($status eq "Console") {
        $p_status = "C";
        $c_status_total++;
     }
     elsif ($status eq "monitor") {
        $p_status = "M";
        $m_status_total++;
     }
     else {
        $p_status = "F";
        $f_status_total++;
     }
     write;

     @asdf = split(/\s+/, $p_cpu2);
     foreach $asdfewq (@asdf) {
        print "*";
     }
   }
}
print "\n";

$status_total = $e_status_total + $c_status_total + $f_status_total +$m_status_total;
print "$e_status_total Ethernet + $c_status_total Console + $m_status_total Monitor + $f_status_total Failed = $status_total Total Devices\n";

disconnect();
