# parse.pl
#
sub parse_ver {
   my ($linePattern, $versionPattern, $cmdResults) = @_;
   my $output;
   if ($cmdResults eq -1) {
      return;
   }

   @lines = split(/\n/, $cmdResults);

   foreach $line (@lines) {
      $_ = $line;
      if (/$linePattern/) {
         if (/$versionPattern/) {
            $output = "$output $&";
         }
      }
   }
   return $output;
}

sub hardware_8540_cpu {
   parse_ver('Route Proc', "[0-9]*[\.][0-9]*", @_);
}

sub hardware_8540_switchc {
   parse_ver('Switch Card', "[0-9]*[\.][0-9]*", @_);
}

1;
