labiv							  labiv
 
NAME
     labiv - produce WAT lab device inventory report
 
SYNOPSIS
     labiv [ -A ] 
     labiv [ -s ] 
     labiv [ -t testbed-name ] [ -c feature ]

DESCRIPTION
     labiv is used to take inventory of lab devices.  Reports
     can be generated for the entire lab based on testbed,
     device, or device feature.
 
OPTIONS
     -A             full lab inventory

		    This option can only be used independently and can take
	            several hours to complete depending on the size of the hostfile.
		    This option generates a separate report for each individual
		    testbed, one report containing all testbed summaries, and a lab-wide 
		    summary of all pertinent device features

     -s 	    hostfile sanity check

		    compares results generated by labiv with 
		    what what devices are in the hostfile and 
		    displays discrepencies.  Also generates logs
		    of what devices were unreachable and what
		    device names are unsupported
 
     -t [testbed-name]   real-time testbed inventory   

		    probes [testbed-name] and outputs results to STDOUT
		    and the summary file for [testbed-name] 	 
                   
     -c [feature]   counts feature     

        	    counts feature and outputs device and its ip address that
		    contain feature to STDOUT.
	
		    features:

			asp=#.#		ATM Switch Processor, version #.# 
			fc=1		Feature Card, version 1
			fc=3		Features Card, version 3
    			mem=16		16MB of memory
	    		mem=24		24MB of memory
    			mem=32		32MB of memory
    			mem=48		48MB of memory
    			mem=64		64MB of memory
    			mem=128		128MB of memory
    			mem=256		256MB of memory
       	         	ls1010		LightStream 1010
			ls1015		LightStream 1015
			2500		2500 Series Routers
			4000		4000 Series Routers
			7000		7000 Series Routers
			7200		7200 Series Routers
			7500		7500 Series Routers
			aip		ATM Interface Processors
			eip		Ethernet Interface Processors
			pa=ether	Ethernet Port Adapters
			pa=oc3		OC3 Port Adapters
			pa=fe		Fast Ethernet Port Adapters
			pa=mce1		OC3 multi-channel E1 Adapters
			pa=ct3		CT3 Port Adapters
			vip2		Versatile Interface Processor 2
			pam=<pam-type>  Port Adaptor Module

			<pam-type>	155MM	
  					155SM  
					155UTP   	 
					155MIXED
			                622SM  
				        622MM    
					DS3    
				  	QDS3
					E1BNC   
					E1RJ45    
					E3    
					T1	                  
					CEST1 
					CT3IP    
					CESE1   
					4CE1

Using the -t option will limit the -c counts to the given testbed.

Examples:

   Generate full summary (probe every testbed)

	%labiv -A

   Run a sanity check against current inventory and hosts file
   (note: labiv -s is automatically run in conjunction with labiv -A)

	%labiv -s

   Count all 155mixed pams

	%labiv -c pam=155mixed

   Count all devices with a feature card version 1

	%labiv -c fc=1

   Generate summary of sbr1 testbed

	%labiv -t sbr1

   Count devices with 32MB memory in fs01 and sbr1 testbeds

	%labiv -t fs01 -c mem=32 -t sbr1

FILES
     full.summary       	lab-wide summary and hostfile sanity check summary

     full.summary.old   	previous lab-wide summary 

     _.inventory	        inventory data file

     _.inventory.bak     	inventory data file backup from last full summary run

     testbeds/<testbed-name>.summary  	testbed summaries

     no-conn.log		a listing of each device labiv could not connect to because
				of absent or incorrect enable password, disabled physical 
				connection, or unrecognizable device type

     unsupported.log		a listing of devices on the network that labiv could not resolve

     hosts			hosts file maintained by lab admin.
				this file is parsed by labiv and devices
				listed must retain the basic format of:
				<ip address> <device name> <termserver connection>
				where device name conforms to a three-letter testbed
				name, followed by an underscore, followed by an 
				approved three-letter device name, followed by an
				underscore, followed by a two-digit number and
				the termserver connection is a comment indicating
				which port on the termserver the device is connected to
